//
//  MPSPopUpButton.h
//  MPServices
//
//  Created by Oleksii Dykan on 6/22/15.
//  Copyright (c) 2015 MacPhun. All rights reserved.
//

#import "MPAbstractButton.h"

@interface MPSPopUpButton : MPAbstractButton

@property (nonatomic, strong) IBOutlet NSMenu *popUpMenu;

@property (readonly, nonatomic, assign) NSInteger indexOfSelectedItem;
@property (readonly, nonatomic, assign) NSInteger selectedTag;
@property (readonly, nonatomic, assign) NSInteger numberOfItems;
@property (readonly, nonatomic, strong) NSMenuItem *selectedItem;

- (void)selectItemAtIndex:(NSInteger)index;
- (BOOL)selectItemWithTag:(NSInteger)tag;
- (void)addItemWithTitle:(NSString *)title;
- (void)addItemsWithTitles:(NSArray *)itemTitles;
- (void)removeAllItems;

@end
